# Biological Clocks and Age Review #
# L.S. Le Clercq #

library(meta)

# 1. Methylation Studies Meta Analysis ####

## 1.1 Data import ####
NEW_MMeth <- read_excel("Data/Le Clercq (2022) - Biological clocks (Data)/5. Meta-Analysis/Methylation/NEW_MMeth.xlsx", 
                        +     col_types = c("text", "text", "text", 
                                            +         "numeric", "text", "text", "numeric", 
                                            +         "numeric", "numeric", "text", "numeric", 
                                            +         "text", "numeric", "numeric", "numeric"))
MMeth <- NEW_MMeth
View(MMeth)
summary(MMeth)
options(scipen=100)
options(digits=3)
pastecs::stat.desc(MMeth)

Meth_Group1 <- subset(MMeth, MMeth$Group==1)
MamMeth <- subset(MMeth, MMeth$Class == 'Mammals')

## 1.2 Factorization of variables ####
MMeth$Class <- factor(MMeth$Class, levels = c("Fishes", "Amphibians", "Reptiles", "Birds", "Mammals"))
MMeth$Bias <- factor(MMeth$Bias, levels = c("Low", "Medium", "High"))
MMeth$Mammal.Group <- factor(MMeth$Mammal.Group)
MMeth$Group <- factor(MMeth$Group, levels = c("1", "2", "3"))

## 1.3 Meta-analysis ####
Author <- MMeth$Author
Species <- MMeth$'Generic name'
Tissue <- MMeth$Tissue

### REM - All ####

Meta.M <- metacor(cor = Cor, n = N, studlab = MMeth$`Generic name`,
                  keepdata = TRUE, data = MMeth, 
                  random = TRUE, common = FALSE, 
                  method.tau = "REML", prediction = TRUE, 
                  sm = "ZCOR", title = "Meta-analysis of Methylation studies")
Meta.M

Meta.MGrp1 <- metacor(cor = Cor, n = N, studlab = MMeth$`Generic name`,
                  keepdata = TRUE, data = MMeth, 
                  random = TRUE, common = FALSE, 
                  method.tau = "REML", prediction = TRUE, 
                  sm = "ZCOR", title = "Meta-analysis of Methylation studies")
Meta.MGrp1

### REM - by Class ####
Meta.M2 <- update.meta(Meta.M, subgroup = MMeth$Class, subgroup.name = "") #Group by Class
Meta.M2

### REM - by Group ####
Meta.M3 <- update.meta(Meta.M, subgroup = MMeth$Group) #by Groups 1-3
Meta.M3

### REM - by Tissue ####
Meta.M4 <- update.meta(Meta.M, subgroup = MMeth$Tissue) #by Tissue #by Groups 1-3
Meta.M4

### REM - by Method ####
Meta.M5 <- update.meta(Meta.M, subgroup = MMeth$Method) #by Tissue #by Groups 1-3
Meta.M5

### REM - Mammals only ####
MamMet <- metacor(cor = Cor, n = N, studlab = MamMeth$`Generic name`,
                  keepdata = TRUE, data = MamMeth, 
                  random = TRUE, common = FALSE, 
                  method.tau = "REML", prediction = TRUE, 
                  sm = "ZCOR", title = "Meta-analysis of Methylation studies")

MamMet.M2 <- update.meta(MamMet, subgroup = MamMeth$Mammal.Group, subgroup.name = "") #Group by species
MamMet.M2

## 1.4 Forest plots ####
ColorScheme <- c('#AB22B8', "#2670D0", "#26D09B", "#EC4FC2", "#EC514F")

### Forest - All ####
png(file = "forestplot - All.png", width = 4500, height = 4000, res = 300)
forest.meta(Meta.M,
            sortvar = MMeth$Class, 
            prediction = TRUE,
            print.tau2 = TRUE,
            just.addcols.left = c("left","left","left","right","left"),
            col.by = "black",
            col.square = "light blue",xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", 
            leftcols = c("studlab", "Author", "Bias", "Group", "n", "Tissue", "TE", "seTE"),
            leftlabs = c("Species", "Author", "Bias", "Grp", "N","Tissue","Fisher's-Z", "SE"))
dev.off()

### Forest - Classes ####
png(file = "forestplot - Classes.png", width = 9000, height = 10000, res = 600)
forest.meta(Meta.M2,
            sortvar = MMeth$Mammal.Group, overall = TRUE,
            prediction = TRUE, subgroup = FALSE, fs.heading = 14,
            addrow.subgroups = TRUE, fs.test.overall = 20,
            print.tau2 = TRUE,
            just.addcols.left = c("left","left","left","right","right","left"),
            col.by = "black", fontfamily = 'sans',
            col.square = ColorScheme[factor(MMeth$Class)],xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", digits.se = 2,
            print.pval.Q = FALSE,
            leftcols = c("studlab", "Author", "Bias", "Group", "n", "Genome.Size","Tissue", "TE", "seTE"),
            leftlabs = c(expression(bold("Species")), expression(bold("Author")),
                         expression(bold("Bias")), expression(bold("Grp")), expression(bolditalic("N")),
                         expression(bold("Genome")), expression(bold("Tissue")),
                         expression(bold("Fisher's"~italic("- Z"))), expression(bold("SE"))))
dev.off()

### Forest - Groups ####
png(file = "forestplot - Groups.png", width = 9000, height = 10000, res = 600)
forest.meta(Meta.M3,
            sortvar = MMeth$Mammal.Group, overall = TRUE,
            prediction = TRUE, subgroup = TRUE, fs.heading = 14,
            addrow.subgroups = TRUE, fs.test.overall = 20,
            print.tau2 = TRUE,
            just.addcols.left = c("left","left","left","right","right","left"),
            col.by = "black", fontfamily = 'sans',
            col.square = "light blue",xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", digits.se = 2,
            print.pval.Q = FALSE,
            leftcols = c("studlab", "Author", "Bias", "Group", "n", "Genome.Size","Tissue", "TE", "seTE"),
            leftlabs = c(expression(bold("Species")), expression(bold("Author")),
                         expression(bold("Bias")), expression(bold("Grp")), expression(bolditalic("N")),
                         expression(bold("Genome")), expression(bold("Tissue")),
                         expression(bold("Fisher's"~italic("- Z"))), expression(bold("SE"))))
dev.off()

### Forest - Tissue ####
png(file = "forestplot - Tissue.png", width = 9000, height = 11000, res = 600)
forest.meta(Meta.M4,
            sortvar = MMeth$Mammal.Group, overall = TRUE,
            prediction = TRUE, subgroup = TRUE, fs.heading = 14,
            addrow.subgroups = TRUE, fs.test.overall = 20,
            print.tau2 = TRUE,
            just.addcols.left = c("left","left","left","right","right","left"), col.by = "black", fontfamily = 'sans',
            col.square = "light blue",xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", digits.se = 2,
            print.pval.Q = FALSE,
            leftcols = c("studlab", "Author", "Bias", "Group", "n", "Genome.Size","Tissue", "TE", "seTE"),
            leftlabs = c(expression(bold("Species")), expression(bold("Author")),
                         expression(bold("Bias")), expression(bold("Grp")), expression(bolditalic("N")),
                         expression(bold("Genome")), expression(bold("Tissue")),
                         expression(bold("Fisher's"~italic("- Z"))), expression(bold("SE"))))
dev.off()

### Forest - Method ####
png(file = "forestplot - Method.png", width = 9000, height = 11000, res = 600)
forest.meta(Meta.M5,
            sortvar = MMeth$Mammal.Group, overall = TRUE,
            prediction = TRUE, subgroup = FALSE, fs.heading = 14,
            addrow.subgroups = TRUE, fs.test.overall = 20,
            print.tau2 = TRUE,
            just.addcols.left = c("left","left","left","right","right","left"), col.square = "light blue",xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", digits.se = 2,
            print.pval.Q = FALSE,
            leftcols = c("studlab", "Author", "Bias", "Group", "n", "Genome.Size","Tissue", "TE", "seTE"),
            leftlabs = c(expression(bold("Species")), expression(bold("Author")),
                         expression(bold("Bias")), expression(bold("Grp")), expression(bolditalic("N")),
                         expression(bold("Genome")), expression(bold("Tissue")),
                         expression(bold("Fisher's"~italic("- Z"))), expression(bold("SE"))))
dev.off()

### Forest - Mammals only ####
png(file = "MammalMeth.png", width = 9000, height = 10000, res = 600)
forest.meta(MamMet.M2,
            sortvar = MamMeth$Mammal.Group, overall = TRUE,
            prediction = TRUE, subgroup = FALSE, fs.heading = 14,
            addrow.subgroups = TRUE, fs.test.overall = 20,
            print.tau2 = TRUE,
            just.addcols.left = c("left","left","left","right","right","left"), col.by = "black", fontfamily = 'sans',
            col.square = "light blue",xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", digits.se = 2,
            print.pval.Q = FALSE,
            leftcols = c("studlab", "Author", "Bias", "Group", "n", "Genome.Size","Tissue", "TE", "seTE"),
            leftlabs = c(expression(bold("Species")), expression(bold("Author")),
                         expression(bold("Bias")), expression(bold("Grp")), expression(bolditalic("N")),
                         expression(bold("Genome")), expression(bold("Tissue")),
                         expression(bold("Fisher's"~italic("- Z"))), expression(bold("SE"))))
dev.off()

## 1.5 Funnel plots (Asymmetry) ####
png(file = "Funnel.png", width = 8000, height = 10000, res = 600)
funnel.meta(Meta.M, random = TRUE,
            xlim = c(-0.5, 3),
            studlab = TRUE)
dev.off()

## 1.6 Publication bias test ####
MMeth_bias <- metabias(Meta.M, method.bias = "linreg",
                       plotit=TRUE, xlab="New")
MMeth_bias

### Pub Bias Plot ####
x <- 1/(MMeth_bias$x$seTE)
y <- MMeth_bias$x$zval
plot(x, y, pch=19, col='purple', xlab = "Inverse of Standard Error (SE)",
     ylab = "Stand. Treatment Effect (TE) Z-score")
abline(lm(y~x))
LimPBM <- lm(y~x)
LimPBM
cor(x,y)

MMeth_biasGrp1 <- metabias(Meta.MGrp1, method.bias = "linreg")
MMeth_biasGrp1

## 1.7 Meta-regression for heterogeneity ####
MREG <- meta::metareg(Meta.M, ~N)
MREG

MREG2 <- meta::metareg(Meta.M, ~Tissue)
MREG2

MREG3 <- meta::metareg(Meta.M, ~Author)
MREG3

MREG4 <- meta::metareg(Meta.M, ~Method)
MREG4

MREG5 <- meta::metareg(Meta.M, ~MMeth$`Life Min`)
MREG5

MREG6 <- meta::metareg(Meta.M, ~MMeth$`Life Med`)
MREG6

MREG7 <- meta::metareg(Meta.M, ~MMeth$`Life Max`)
MREG7

MREG8 <- meta::metareg(Meta.M, ~Class)
MREG8

Meta.M$data$Year <- as.character(Meta.M$data$Year)
MREG9 <- meta::metareg(Meta.M, ~Year)
MREG9

MREG10 <- meta::metareg(Meta.M, ~Bias)
MREG10

MREG10_2 <- meta::metareg(Meta.M, ~Cal.Bias)
MREG10_2

### Bubble plot for Author Bias ####
ColorScheme = c("green","yellow","red")
metafor::regplot(MREG10_2, 
                 xlab="Author Bias (paper)", ylab="Fisher's-Z", refline=0,
                 digits=1, las=1, bty="l", atransf=transf.rtoz(Meta.M$TE),
                 labsize=0.9,
                 bg=ColorScheme[factor(Bias)],
                 title="Bubbleplot of Meta-Regression for Author Bias")

LimM <- lm(Meta.M$TE~Meta.M$data$Cal.Bias)
LimM
summary(LimM)

MREG11 <- meta::metareg(Meta.M, ~Genome.Size)
MREG11

# 2. Telomere studies Meta Analysis ####
## 2.1 Data import ####
NEW_MTel <- read_excel("Data/Le Clercq (2022) - Biological clocks (Data)/5. Meta-Analysis/Telomeres/All/NEW_MTel.xlsx", 
                       +     col_types = c("text", "text", "text", 
                                           +         "text", "text", "numeric", "numeric", 
                                           +         "numeric", "numeric", "text", "text", 
                                           +         "numeric", "text", "text", "numeric", 
                                           +         "numeric", "numeric"))
MTel <- NEW_MTel
MTel_All <- MTel_ALL
View(MTel)
summary(MTel)
pastecs::stat.desc(MTel_All)

## 2.2 Factorization of variables ####
MTel$Class <- factor(MTel$Class, levels = c("Fishes", "Amphibians", "Reptiles", "Birds", "Mammals"))
MTel$Bias <- factor(MTel$Bias, levels = c("Low", "Medium", "High"))
MTel$Mammal.Group <- factor(MTel$Mammal.Group)
MTel$Group <- factor(MTel$Group, levels = c("1", "2", "3"))

## 2.3 Meta-analysis ####
Author2 <- MTel$Author
Species2 <- MTel$`Generic name`
Tissue2 <- MTel$Tissue

### REM - All ####
Meta.T <- meta::metagen(TE = TE, seTE = seTE,
                        data = MTel_All,random = TRUE,sm = "ZCOR",
                        common = FALSE,keepdata = TRUE, 
                        method.tau = "REML", prediction = TRUE)
Meta.T

### REM - by Class ####
Meta.T2 <- update.meta(Meta.T, subgroup = MTel$Class, subgroup.name = "") #Group by Class
Meta.T2

### REM - by Group ####
Meta.T3 <- update.meta(Meta.T, subgroup = MTel$Group) #by Groups 1-2
Meta.T3

### REM - by Tissue ####
Meta.T4 <- update.meta(Meta.T, subgroup = MTel$Tissue.2) #by Tissue
Meta.T4

### REM - by Method ####
Meta.T5 <- update.meta(Meta.T, subgroup = MTel$Method) #by Method
Meta.T5

## 2.4 Forest plots ####
#ColorScheme <- c("purple", "blue", "green", "yellow", "red")

### Forest - All ####
png(file = "forestplot - All (Tel).png", width = 9000, height = 4000, res = 300)
forest.meta(Meta.T,
            sortvar = MTel$Class, 
            prediction = TRUE,
            print.tau2 = TRUE,
            just.addcols.left = c("left","left","left","right","right","left"),          col.by = "black",
            col.square = "light blue",xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", 
            print.pval.Q = FALSE,
            leftcols = c("studlab", "Author", "Bias", "Group", "n", "Karyotype","Tissue", "TE", "seTE"),
            leftlabs = c(expression(bold("Species")), expression(bold("Author")),
                         expression(bold("Bias")), expression(bold("Grp")), expression(bolditalic("N")),
                         expression(bold("Karyotype")), expression(bold("Tissue")),
                         expression(bold("Fisher's"~italic("- Z"))), expression(bold("SE"))))
dev.off()

### Forest - Classes ####
png(file = "forestplot - Classes (Tel).png", width = 9100, height = 10000, res = 600)
forest.meta(Meta.T2,
            sortvar = MTel$Mammal.Group, overall = TRUE,
            prediction = TRUE, subgroup = FALSE, fs.heading = 14,
            addrow.subgroups = TRUE, fs.test.overall = 20,
            print.tau2 = TRUE,
            just.addcols.left = c("left","left","left","right","right","left"),
            col.by = "black", fontfamily = 'sans',
            col.square = ColorScheme[factor(MTel$Class)],xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", digits.se = 2,
            print.pval.Q = FALSE,
            leftcols = c("studlab", "Author", "Bias", "Group", "N", "Karyotype","Tissue", "TE", "seTE"),
            leftlabs = c(expression(bold("Species")), expression(bold("Author")),
                         expression(bold("Bias")), expression(bold("Grp")), expression(bolditalic("N")),
                         expression(bold("Karyo")), expression(bold("Tissue")),
                         expression(bold("Fisher's"~italic("- Z"))), expression(bold("SE"))))
dev.off()

### Forest - Groups ####
png(file = "forestplot - Groups (Tel).png", width = 9100, height = 10000, res = 600)
forest.meta(Meta.T3,
            sortvar = MTel$Mammal.Group, overall = TRUE,
            prediction = TRUE, subgroup = TRUE, fs.heading = 14,
            addrow.subgroups = TRUE, fs.test.overall = 20,
            print.tau2 = TRUE,
            just.addcols.left = c("left","left","left","right","right","left"),
            col.by = "black", fontfamily = 'sans',
            col.square = "light blue",xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", digits.se = 2,
            print.pval.Q = FALSE,
            leftcols = c("studlab", "Author", "Bias", "Group", "N", "Karyotype","Tissue", "TE", "seTE"),
            leftlabs = c(expression(bold("Species")), expression(bold("Author")),
                         expression(bold("Bias")), expression(bold("Grp")), expression(bolditalic("N")),
                         expression(bold("Karyo")), expression(bold("Tissue")),
                         expression(bold("Fisher's"~italic("- Z"))), expression(bold("SE"))))
dev.off()

### Forest - Tissue ####
png(file = "forestplot - Tissue (Tel).png", width = 9100, height = 11200, res = 600)
forest.meta(Meta.T4,
            sortvar = MTel$Mammal.Group, overall = TRUE,
            prediction = TRUE, subgroup = TRUE, fs.heading = 14,
            addrow.subgroups = TRUE, fs.test.overall = 20,
            print.tau2 = TRUE,
            just.addcols.left = c("left","left","left","right","right","left"),
            col.by = "black", fontfamily = 'sans',
            col.square = "light blue",xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", digits.se = 2,
            print.pval.Q = FALSE,
            leftcols = c("studlab", "Author", "Bias", "Group", "N", "Karyotype","Tissue", "TE", "seTE"),
            leftlabs = c(expression(bold("Species")), expression(bold("Author")),
                         expression(bold("Bias")), expression(bold("Grp")), expression(bolditalic("N")),
                         expression(bold("Karyo")), expression(bold("Tissue")),
                         expression(bold("Fisher's"~italic("- Z"))), expression(bold("SE"))))
dev.off()

### Forest - Method ####
png(file = "forestplot - Method (Tel).png", width = 9100, height = 11000, res = 600)
forest.meta(Meta.T5,
            sortvar = MTel$Mammal.Group, overall = TRUE,
            prediction = TRUE, subgroup = TRUE, fs.heading = 14,
            addrow.subgroups = TRUE, fs.test.overall = 20,
            print.tau2 = TRUE,
            just.addcols.left = c("left","left","left","right","right","left"),            col.by = "black", fontfamily = 'sans',
            col.square = "light blue",xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", digits.se = 2,
            print.pval.Q = FALSE,
            leftcols = c("studlab", "Author", "Bias", "Group", "N", "Karyotype","Tissue", "TE", "seTE"),
            leftlabs = c(expression(bold("Species")), expression(bold("Author")),
                         expression(bold("Bias")), expression(bold("Grp")), expression(bolditalic("N")),
                         expression(bold("Karyo")), expression(bold("Tissue")),
                         expression(bold("Fisher's"~italic("- Z"))), expression(bold("SE"))))
dev.off()

## 2.5 Funnel plots (Asymmetry) ####
png(file = "Funnel (Tel).png", width = 9000, height = 10000, res = 600)
funnel.meta(Meta.T, random = TRUE,
            xlim = c(-0.5, 3),
            studlab = TRUE)
dev.off()

## 2.6 Publication bias test ####
MTel_bias <- metabias(Meta.T, method.bias = "linreg",
                      plotit = TRUE)
MTel_bias

### Pub Bias Plot ####
x2 <- 1/(MTel_bias$x$seTE)
y2 <- MTel_bias$x$zval

plot(x2, y2, pch=19, col='purple', xlab = "Inverse of Standard Error (SE)",
     ylab = "Stand. Treatment Effect (TE) Z-score")
abline(lm(y2~x2))
LimPBT <- lm(y2~x2)
LimPBT

#### With filtering ####
Spss <- MTel_bias$x$data$Class

DF1 <- cbind.data.frame(x2,y2,Spss)
DF1

DF2 <- DF1 %>%
  filter(DF1$x2 < 100)
DF2
DF2$Spss <- as.factor(DF2$Spss)

plot(DF2$x2, DF2$y2, pch=19, col="purple",
     xlab = "Inverse of Standard Error (SE)",
     ylab = "Stand. Treatment Effect (TE) Z-score")
abline(lm(DF2$y2~DF2$x2))
LimPBT2 <- lm(DF2$y2~DF2$x2)
LimPBT2
cor(DF2$x2,DF2$y2)

## 2.7 Meta-regression for heterogeneity ####
TREG <- meta::metareg(Meta.T, ~N)
TREG

TREG2 <- meta::metareg(Meta.T, ~Tissue.2)
TREG2

TREG3 <- meta::metareg(Meta.T, ~Author)
TREG3

TREG4 <- meta::metareg(Meta.T, ~Method)
TREG4

TREG5 <- meta::metareg(Meta.T, ~MTel$`Life Min`)
TREG5

TREG6 <- meta::metareg(Meta.T, ~MTel$`Life Med`)
TREG6

TREG7 <- meta::metareg(Meta.T, ~MTel$`Life Max`)
TREG7

TREG8 <- meta::metareg(Meta.T, ~Class)
TREG8

Meta.T$data$Year <- as.character(Meta.T$data$Year)
TREG9 <- meta::metareg(Meta.T, ~Year)
TREG9

TREG10 <- meta::metareg(Meta.T, ~Bias)
TREG10

TREG10_2 <- meta::metareg(Meta.T, ~Cal.Bias)
TREG10_2

### Bubble plot for Author Bias ####
ColorScheme = c("red","green","yellow")
metafor::regplot(TREG10_2,
                 xlab="Author Bias (paper)", ylab="Fisher's-Z",
                 digits=1, las=1, bty="l",
                 labsize=0.9,
                 bg=ColorScheme[factor(Bias)],
)

LimT <- lm(Meta.T$TE~Meta.T$data$Cal.Bias)
LimT
summary(LimT)

TREG11 <- meta::metareg(Meta.T, ~Karyotype)
TREG11

# 3. Comparison between methods ####

## 3.1 Statistical analysis ####
library("metafor")

### Methylation ####
MethTE <- Meta.M$TE
MethTE <- as.list(MethTE)
MethTE <- as.numeric(MethTE)
MethseTE <- Meta.M$seTE
MethseTE <- as.list(MethseTE)
MethseTE <- as.numeric(MethseTE)
Methylation <- rma(MethTE,MethseTE)

### Telomeres ####
TelTE <- Meta.T$TE
TelTE <- as.list(TelTE)
TelTE <- as.numeric(TelTE)
TelseTE <- Meta.T$seTE
TelseTE <- as.list(TelseTE)
TelseTE <- as.numeric(TelseTE)
Telomeres <- rma(TelTE,TelseTE)

### Combined data ####
dat.comp <- data.frame(estimate = c(coef(Methylation), coef(Telomeres)), stderror = c(Methylation$se, Telomeres$se),
                       meta = c("Methylation","Telomeres"), tau2 = round(c(Methylation$tau2, Telomeres$tau2),3))
dat.comp

### Analysis ####
Comb.M <- rma(estimate, sei=stderror, mods = ~ meta, method="FE", data=dat.comp, digits=3)
Comb.M
forest(Comb.M)

### Comparison of sample sizes ####
t.test(MMeth$N, MTel$N)

## 3.2 Forest plot ####
Combined <- meta::metabind(Meta.M, Meta.T, name = c("Methylation", "Telomeres"), pooled = "random")
forest(Combined, prediction = TRUE,
       print.tau2 = TRUE,
       col.by = "black",
       col.square = "light blue",xlim = c(-1,1),
       col.diamond = "yellow")

# 4. Bird Telomeres Meta analyses ####
## 4.1 Data import ####
MBird <- read.csv("~/7. Manuscripts/3. Age Review/Le Clercq (2022) - Biological clocks (Data)/4. Meta-Analysis/MBird.csv")

View(MBird)
summary(MBird)

## 4.2 Meta-analysis ####
Author3 <- MBird$Author
Species3 <- MBird$Generic.name
Tissue3 <- MBird$Tissue
Meta.Bird <- meta::metagen(TE = TE, seTE = seTE,
                        studlab = Generic.name,
                        data = MBird,random = TRUE,sm = "ZCOR",
                        common = FALSE,keepdata = TRUE, 
                        method.tau = "REML", prediction = TRUE)
Meta.Bird

Meta.B2 <- update.meta(Meta.Bird, subgroup = MBird$Class, subgroup.name = "")
Meta.B2

## 4.3 Forest plot ####
png(file = "forestplotBirds.png", width = 4000, height = 6500, res = 300)
forest.meta(Meta.Bird,
            sortvar = TE, 
            prediction = TRUE,
            print.tau2 = TRUE,
            just.addcols.left = "left", just.addcols.right = "right",
            col.by = "black",
            col.square = "light blue",xlim = c(-1,1),
            col.diamond = "yellow",
            colgap = "4mm", subgroup.name = "Tissue",
            leftcols = c("studlab", "Author", "TE", "seTE", "N", "Tissue"),
            leftlabs = c("Species", "Author","Fisher's-Z", "SE","N","Tissue"))
dev.off()

png(file = "Birds - forestplot - Classes (Tel).png", width = 8500, height = 11000, res = 600)
forest.meta(Meta.B2,
            sortvar = MBird$Class, overall = TRUE,
            prediction = TRUE, subgroup = FALSE, fs.heading = 14,
            addrow.subgroups = TRUE, fs.test.overall = 20,
            print.tau2 = TRUE,
            just.addcols.left = c("left","right","right","left"),
            col.by = "black", fontfamily = 'sans',
            col.square = "#EC4FC2" ,xlim = c(-2,2),
            col.diamond = "yellow",
            colgap = "4mm", digits.se = 2,
            print.pval.Q = FALSE,
            leftcols = c("studlab", "Author", "N", "Karyotype","Tissue", "TE", "seTE"),
            leftlabs = c(expression(bold("Species")), expression(bold("Author")), expression(bolditalic("N")),
                         expression(bold("Karyo")), expression(bold("Tissue")),
                         expression(bold("Fisher's"~italic("- Z"))), expression(bold("SE"))))
dev.off()

## 4.4 Test of bias ####
Bird_bias <- metabias(Meta.Bird, method.bias = "linreg")
Bird_bias

## 4.5 Meta-regression for heterogeneity ####
BREG <- meta::metareg(Meta.Bird, ~N)
BREG

BREG2 <- meta::metareg(Meta.Bird, ~Tissue.2)
BREG2

BREG3 <- meta::metareg(Meta.Bird, ~Author)
BREG3

BREG4 <- meta::metareg(Meta.Bird, ~Method)
BREG4

BREG5 <- meta::metareg(Meta.Bird, ~Life.Min)
BREG5

BREG6 <- meta::metareg(Meta.Bird, ~Life.Med)
BREG6

BREG7 <- meta::metareg(Meta.Bird, ~Life.Max)
BREG7

BREG8 <- meta::metareg(Meta.Bird, ~Class)
BREG8

BREG9 <- meta::metareg(Meta.Bird, ~Year)
BREG9

#5. Adjusting for Publication Bias ####

## 5.1 Methylation Trim and Fill ####
mtaf <- trimfill(Meta.M)
mtaf

png(file = "forestplot - Trim and Fill (Meth).png", width = 4000, height = 6000, res = 300)
forest.meta(mtaf)
dev.off()

## 5.2 Methylation: Linear model ####
Meth <- rma.uni(TE,seTE^2,mods = seTE,data = Meta.M, method = 'FE')
Meth

## 5.3 Telomeres Trim and Fill ####
ttaf <- trimfill(Meta.T)
ttaf

png(file = "forestplot - Trim and Fill (Telo).png", width = 4000, height = 7000, res = 300)
forest.meta(ttaf)
dev.off()

## 5.4 Telomeres: Linear Model ####
Telo <- rma.uni(MTel_All$TE, MTel_All$seTE^2, mods = ~MTel_All$seTE, data=MTel_All, method = 'FE')
Telo
